function ex_11
clear;clc
close all

solinit=bvpinit(linspace(2,3,10),[18 2]);
sol=bvp4c(@ODEfun,@BCfun,solinit);
x=[2:0.01:3];
y=deval(sol,x);
yp=@(x)(x.^2+8./x); %̵ľȷ
figure;plot(x,yp(x),'b',x,y(1,:),'r')
legend('Analytical Solution','Numerical Solution','location','Northwest')
legend boxoff
figure;plot(x,yp(x)-y(1,:),'r')
legend('error')

% ODEfun
function dydx=ODEfun(x,y)
dydx=[y(2);-y(1)*y(2)/4+x^3/2+4];
% BCfun
function bc=BCfun(ya,yb)
bc=[ya(1)-8;yb(1)-35/3];
